package pl.gda.pg.concurrency;

import pl.gda.pg.concurrency.atomicity.AtomicCounter;
import pl.gda.pg.concurrency.atomicity.BlockinQueueDemo;
import pl.gda.pg.concurrency.executors.MyExecutors;
import pl.gda.pg.concurrency.forks.ForksDemo;
import pl.gda.pg.concurrency.locks.LockDemo;
import pl.gda.pg.concurrency.locks.SynchrLock;


//@author Paweł Kaczmarek, Jan Cychnerski


public class MainClass {
    public static void main(String[] args) throws Exception {
        showLocks();
		showExecutors();
        showScheduledExecutors();
		showForks();
        showAtomic();
        showQueue();
	}

    private static void showLocks() throws InterruptedException {
        LockDemo demo = new LockDemo();

        demo.tryDeadlock();
        demo.tryNonDeadlock();

        SynchrLock synchrLock = new SynchrLock();
        synchrLock.testSynchr();

		System.out.println("Main thread finished");
    }

    private static void showScheduledExecutors() throws InterruptedException {
        MyExecutors myExec = new MyExecutors();
        myExec.testScheduleExecutor();
    }

    private static void showExecutors() throws Exception {
        MyExecutors myExec = new MyExecutors();

        myExec.testThreadPool();
        myExec.testOtherExecutors();
        myExec.testCallableCall();

        System.out.println("Main thread finished");
    }

    private static void showForks() {
        ForksDemo.showForkDemoTask();
        ForksDemo.showForkDemoAction();
    }

    private static void showAtomic() {
        AtomicCounter counter = new AtomicCounter();
        counter.getAndIncrement();
        counter.incrementAndGet();
    }

    private static void showQueue() {
        BlockinQueueDemo queue = new BlockinQueueDemo();
        queue.showDemo();
    }
}
